
$(function() {
	if(typeof(localStorage) != "undefined") {
		$('.lien_cahier').each(function() {
			var id_cahier = $(this).data('id_cahier');
			var infos = JSON.parse(localStorage.getItem(id_cahier));
			if(typeof(infos) == "object" && infos!=null) {
				date = new Date(infos['mtime']);
				if(date != null && !isNaN(date.getTime())) {
					var now = new Date();
					var njours = new Number((now.getTime() - date.getTime())/1000/60/60/24);
					if(njours > 30) classe = "j30";
					else if(njours > 14) classe = "j15";
					else if(njours > 6) classe = "j6";
					else classe = "";
					$(this).append('<span class="last_modification '+classe+'">'+njours.toFixed(0)+'</span>');
				} else {
					$(this).append('<span class="last_modification jx">+</span>');
				}
			}
		});
	}
});
